#!perl

# Takes an input .dat file, and prints out a 3D STL version.

# Usage: dat2stl.pl airfoil.dat >airfoil.stl

die "usage: $0 filename.dat" unless($ARGV[0]);

open(IN,'<',$ARGV[0]) or die $!;

@foil=<IN>; close(IN);

$foil[0]='' unless($foil[0]=~/^\s*[\d\-]/); # ignore 1st line if it doesn't begin with a number

my(@x,@y);

foreach (@foil) {
  next if (/^$/);
  $_=~s/^\s+//;
  ($x,$y)=split(/\s+/);
  # print "($x,$y)\n";
  push @x,$x; push @y,$y;
}

print "solid $ARGV[0] created by $0\n";

for(my $i=0;$i<$#x;$i++) {	# skips last deliberately

  # Make a square, starting with one triangle:

  @{$v[0]}=($x[$i],$y[$i],-1);
  @{$v[1]}=($x[$i],$y[$i],1);
  @{$v[2]}=($x[$i+1],$y[$i+1],-1);

#  @{$v[0]}=(	$y[$i]		,-1	,$x[$i]		);
#  @{$v[1]}=(	$y[$i+1]	,1	,$x[$i+1]	);
#  @{$v[2]}=(	$y[$i]		,1	,$x[$i]		);

  print " facet normal " . join(' ',&normal(@v)) . "\n";

#  @{$v[3]}=@{$v[0]};

  print "  outer loop\n";
    foreach $vx(@v) {
      print "   vertex " . join(' ',@{$vx}) . "\n";
    }
  print "  endloop\n";
  print " endfacet\n";
  @v=();

  # And now the second:-

  @{$v[0]}=($x[$i],$y[$i],1);
  @{$v[1]}=($x[$i+1],$y[$i+1],1);
  @{$v[2]}=($x[$i+1],$y[$i+1],-1);

  print " facet normal " . join(' ',&normal(@v)) . "\n";

#  @{$v[3]}=@{$v[0]};

  print "  outer loop\n";
    foreach $vx(@v) {
      print "   vertex " . join(' ',@{$vx}) . "\n";
    }
  print "  endloop\n";
  print " endfacet\n";

}


print "endsolid $ARGV[0]\n";




=for looking

solid MYSOLID created by IVREAD, original data in cube.iv
  facet normal   0.000000E+00  0.000000E+00   1.00000    
    outer loop
      vertex  -0.500000     -0.500000       1.00000    
      vertex   0.500000     -0.500000       1.00000    
      vertex   0.500000      0.500000       1.00000    
      vertex  -0.500000      0.500000       1.00000    
    endloop
  endfacet
  facet normal   0.000000E+00  0.000000E+00  -1.00000    
    outer loop
      vertex   0.500000     -0.500000      0.000000E+00
      vertex  -0.500000     -0.500000      0.000000E+00
      vertex  -0.500000      0.500000      0.000000E+00
      vertex   0.500000      0.500000      0.000000E+00
    endloop
  endfacet
  facet normal   -1.00000      0.000000E+00  0.000000E+00
    outer loop
      vertex  -0.500000     -0.500000      0.000000E+00
      vertex  -0.500000     -0.500000       1.00000    
      vertex  -0.500000      0.500000       1.00000    
      vertex  -0.500000      0.500000      0.000000E+00
    endloop
  endfacet
  facet normal    1.00000      0.000000E+00  0.000000E+00
    outer loop
      vertex   0.500000     -0.500000       1.00000    
      vertex   0.500000     -0.500000      0.000000E+00
      vertex   0.500000      0.500000      0.000000E+00
      vertex   0.500000      0.500000       1.00000    
    endloop
  endfacet
  facet normal   0.000000E+00  -1.00000      0.000000E+00
    outer loop
      vertex  -0.500000     -0.500000      0.000000E+00
      vertex   0.500000     -0.500000      0.000000E+00
      vertex   0.500000     -0.500000       1.00000    
      vertex  -0.500000     -0.500000       1.00000    
    endloop
  endfacet
  facet normal   0.000000E+00   1.00000      0.000000E+00
    outer loop
      vertex  -0.500000      0.500000       1.00000    
      vertex   0.500000      0.500000       1.00000    
      vertex   0.500000      0.500000      0.000000E+00
      vertex  -0.500000      0.500000      0.000000E+00
    endloop
  endfacet
endsolid MYSOLID


print &normal([qw(  -0.500000     -0.500000       1.00000  )],
	      [qw(   0.500000     -0.500000       1.00000  )],
	      [qw(   0.500000      0.500000       1.00000  )] );

print "\n";

print join("\t", &normal([qw(  1     0     0  )],
		         [qw(  0     1     0  )],
		         [qw(  0     0     1  )] ));


print "\n";

=cut

sub normal {	# from http://www.opengl.org/wiki/Calculating_a_Surface_Normal
  my($p1,$p2,$p3)=@_; my($x,$y,$z)=(0,1,2);

  my($N,$U,$V);

  $U->[$x]=$p2->[$x] - $p1->[$x];
  $U->[$y]=$p2->[$y] - $p1->[$y];
  $U->[$z]=$p2->[$z] - $p1->[$z];

  $V->[$x]=$p3->[$x] - $p1->[$x];
  $V->[$y]=$p3->[$y] - $p1->[$y];
  $V->[$z]=$p3->[$z] - $p1->[$z];

  $N->[$x]=$U->[$y]*$V->[$z] - $U->[$z]*$V->[$y];
  $N->[$y]=$U->[$z]*$V->[$x] - $U->[$x]*$V->[$z];
  $N->[$z]=$U->[$x]*$V->[$y] - $U->[$y]*$V->[$x];

  return ($N->[$x],$N->[$y],$N->[$z]);
}
